// CUserDict.cp
// CUserDict.h
// ----------------------------------------------------------------------------------
// The user dictionary class.
//
// This dictionary is a dictionary that is created by users.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original
//		Clark Goble			08/13/94
//			Checked it over and made a few modifications as part of the
//			C++ conversion.
// ----------------------------------------------------------------------------------

#include "UBloom.h"
#include <stdio.h>
#include "CDict.h"
#include "UExtend.h"
#include "Uio.h"

#define USERMAGIC "#UserDictionary"
#define MaxPathLength 100

class CUserDict : public CDict, public UExtended  {
public:

	CUserDict(long NumBuffers, FioParam * theFile);
	virtual ~CUserDict();

	short 	Add(char *Word);
	short  	Check(char *Word);
	long		CountWords(FioParam * UserDictionary);
	short 	LoadUserDictionary(FioParam * UserDictionary);
	short  	ReAllocate(long NumWords);
//	void 		SetName(FioParam * UserDictionary);
//	void 		GetName(FioParam * UserDictionary);
	short  	InitUserDictionary(FioParam * UserDictionaryName,long NumWords);

protected:

	UBloom		*WordList;		// bloom filter of words
	FioParam 	*UserDict;		// file name -- TO CONVERT
	long			EndofFile;		// position of EOF
	long			NumWords;		// number of words in the dictionary
	long			MaxWords;		// Max number of words in filter
	short			Usable;			// does the dictionary work?
	
	CallBackProc	UsrDctCall;
	
}; // CUserDict

